# SumberAI - Peringatan Dini Kekeringan & Manajemen Air Desa

Aplikasi web untuk sistem peringatan dini kekeringan dan manajemen air desa menggunakan AI.

## Fitur Utama

1. **AI Prediksi Kekeringan** - Prediksi risiko kekeringan 7 hari ke depan
2. **Peta Real-Time** - Monitoring kondisi desa secara real-time dengan heatmap
3. **Notifikasi Hemat Air** - Peringatan dini untuk warga
4. **AI Penjadwalan Tangki** - Penjadwalan distribusi air yang efisien
5. **Dashboard Admin** - Manajemen lengkap untuk admin
6. **Laporan Warga** - Sistem pelaporan kondisi air
7. **Export Laporan** - Export PDF dan Excel

## Instalasi

1. Upload semua file ke hosting Anda
2. Import database dari file `database.sql`
3. Edit file `config/database.php` dengan kredensial database Anda
4. Edit `config/config.php` untuk mengatur `APP_URL`
5. Akses aplikasi melalui browser

## Default Login

- **Username:** admin
- **Password:** admin123

## Struktur Folder

```
sumberaifix/
├── admin/          # Halaman admin
├── assets/         # CSS, JS, images
├── auth/           # Login, register, logout
├── config/         # Konfigurasi database
├── distribusi/     # Modul distribusi tangki
├── includes/       # File include (sidebar, dll)
├── laporan/        # Modul laporan warga
├── libs/           # Library (FPDF, dll)
├── peta/           # Modul peta desa
├── prediksi/       # Modul prediksi AI
└── index.php       # Landing page
```

## Teknologi

- PHP Native (tanpa framework)
- MySQL/MariaDB
- HTML5, CSS3, JavaScript
- Leaflet.js (untuk peta)
- Font Awesome (untuk icons)

## Fitur Admin

- Kelola pengguna (tambah, edit, reset password)
- Kelola desa dan dusun
- Kelola menu icons
- Generate prediksi AI
- Export laporan PDF/Excel
- Verifikasi laporan warga

## Fitur Warga

- Daftar akun
- Buat laporan kondisi air
- Lihat prediksi kekeringan
- Lihat peta desa
- Terima notifikasi

## Copyright

@2025 Skipotech Innovation. All rights reserved.

## Support

Untuk bantuan, silakan hubungi tim development.

